#!/usr/bin/env python
# Copyright (c) 2011 Citrix Systems, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation; version 2.1 only. with the special
# exception on linking described in file LICENSE.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

import sys
import time

def getvmstat():
    vmstat = {}
    
    fh = open("/proc/vmstat")
    for line in fh:
        field, val = line.strip().split()
        vmstat[field] = val
    fh.close()

    return vmstat

if __name__ == "__main__":
    st = getvmstat()
    pgpgin1 = float(st['pgpgin'])
    pgpgout1 = float(st['pgpgout'])

    time.sleep(1)

    st = getvmstat()
    pgpgin2 = float(st['pgpgin'])
    pgpgout2 = float(st['pgpgout'])
    
    sys.stdout.write("%f,%f" % ((pgpgin2-pgpgin1), (pgpgout2-pgpgout1)))
    
