#!/bin/bash

# COPYRIGHT 2003-2014, EMULEX CORPORATION                               
# 3333 Susan St., Costa Mesa, CA 92626                                  
#                                                                         
# All rights reserved.  This computer program and related documentation 
# is protected by copyright  and distributed under licenses restricting 
# its use,  copying,  distribution  and decompilation.    This computer 
# program  and its  documentation  are CONFIDENTIAL  and a TRADE SECRET 
# of EMULEX CORPORATION.   The receipt or  possession of  this  program 
# or its documentation does not  convey rights to reproduce or disclose 
# its  contents,  or to  manufacture, use, or sell anything that it may 
# describe, in whole or in part,  without the specific  written consent 
# of  EMULEX CORPORATION.   Any reproduction  of  this program  without 
# the express  written  consent  of EMULEX  CORPORATION  is a violation 
# of the  copyright laws  and may  subject you to  criminal prosecution.

SUCCESS=0
FAILURE=1
STATUS=$SUCCESS
KITNAME=""
LOGFILE_NAME="utils-install.log"
INSTALL_DIR="usr/sbin/ocmanager"
LOGFILE="/${INSTALL_DIR}/${LOGFILE_NAME}"
# Function:  log_message()
#
# Description:
#   Print the strings passed as parameters to both STDOUT as well as
#   to a log file.
#
# Parameters:
#   A series of strings.
#
# Returns:
#   0 on success.
log_message()
{
    local ECHO_OPTIONS
    LOGDIRECTORY=${LOGFILE%/*}
    if [ ! -d ${LOGDIRECTORY} ] ; then
        mkdir -p ${LOGDIRECTORY}
    fi

    if [ $# -eq 0 ] ; then
        echo "" | tee -a ${LOGFILE}
    elif [ -z "$1" ] ; then
        echo "" | tee -a ${LOGFILE}
    elif [ "$1" = "-init" ] ; then
        echo "$0 - $(date)" >> ${LOGFILE}
    else
        while [ -n "$1" ] ; do
            if [ "${1:0:1}" = "-" ] ; then
                ECHO_OPTIONS="${1}"
            else
                echo ${ECHO_OPTIONS} "$1" | tee -a ${LOGFILE}
            fi
            shift
        done
    fi
    return $SUCCESS
}


# Initialize the log file.
log_message -init
rpm -q --quiet OneCommandVisionSensor
if [ $? -eq 0 ]; then
    SENSOR_RPM=`rpm -q OneCommandVisionSensor`
    log_message "Warning: sensor component will be un-installed as it is dependent on OCM."
    log_message "Do you want to proceed?"
    log_message "Enter y to uninstall both OCM and OCV sensor. "
    log_message "Enter n to keep OCM and OCV sensor. "
    log_message -n "Enter the letter 'y' or 'n'"
    read uninstall_sensor
    if [ "$uninstall_sensor" == "Y" ] || [ "$uninstall_sensor" == "y" ]; then
        log_message "Uninstalling OneCommand Sensor and OneCommand Manager kits."
        
        if [ -f /${INSTALL_DIR}/scripts/OneCommandVisionSensor*/uninstall-sensor ]; then
            /${INSTALL_DIR}/scripts/OneCommandVisionSensor*/uninstall-sensor
        else
            echo "Uninstalling OneCommandVisionSensor: $SENSOR_RPM"
            rpm -ev $SENSOR_RPM
        fi
        
        SENSORSTATUS=$?
        if [ "$SENSORSTATUS" = "0" ];then
            log_message "Uninstalling OneCommandVisionSensor completed successfully"
        else
            log_message "An error occured while uninstalling  OneCommandVisionSensor"
            STATUS=$FAILURE
        fi
    else
        exit  $SUCCESS
    fi
    log_message ""
fi
rpm -q --quiet elxocmgui
if [ $? -eq 0 ]; then
    HBAGUIQUERY=`rpm -q elxocmgui`
    KITNAME="Enterprise"
    log_message "Uninstalling elxocmgui: $HBAGUIQUERY"
    rpm -e $HBAGUIQUERY
    GUISTATUS=$?
    if [ "$GUISTATUS" = "0" ];then
        log_message "Uninstalling $HBAGUIQUERY completed successfully"
    else
        log_message "An error occurred while uninstalling $HBAGUIQUERY"
        STATUS=$FAILURE
    fi
    log_message ""
fi

rpm -q --quiet elxocmjvm
if [ $? -eq 0 ]; then
    HBAJVMQUERY=`rpm -q elxocmjvm`
    KITNAME="Enterprise"
    log_message "Uninstalling elxocmjvm: $HBAJVMQUERY"
    rpm -e $HBAJVMQUERY
    JVMSTATUS=$?
    if [ "$JVMSTATUS" = "0" ];then
        log_message "Uninstalling $HBAJVMQUERY completed successfully"
    else
        log_message "An error occurred while uninstalling $HBAJVMQUERY"
        STATUS=$FAILURE
    fi
    log_message ""
fi

rpm -q --quiet elxocmcore
if [ $? -eq 0 ]; then
    if [ -z $KITNAME ]; then
        KITNAME="Core"
    fi
    HBACOREQUERY=`rpm -q elxocmcore`
    log_message "Uninstalling elxocmcore: $HBACOREQUERY"
    rpm -e $HBACOREQUERY
    CORESTATUS=$?
    if [ "$CORESTATUS" = "0" ];then
        log_message "Uninstalling $HBACOREQUERY completed successfully"
    else
        log_message "An error occurred while uninstalling $HBACOREQUERY"
        STATUS=$FAILURE
    fi
    log_message ""
fi

rpm -q --quiet elxocmcorelibs
if [ $? -eq 0 ]; then
    if [ -z $KITNAME ]; then
        KITNAME="Core"
    fi
    HBACORELIBSQUERY=`rpm -q elxocmcorelibs`
    log_message "Uninstalling elxocmcorelibs: $HBACORELIBSQUERY"
    rpm -e $HBACORELIBSQUERY
    CORELIBSSTATUS=$?
    if [ "$CORELIBSSTATUS" = "0" ];then
        log_message "Uninstalling $HBACORELIBSQUERY completed successfully"
    else
        log_message "An error occurred while uninstalling $HBACORELIBSQUERY"
        STATUS=$FAILURE
    fi
    log_message ""
fi

echo $* | grep -q "all-libs"
if [ $? -eq 0 ]; then
    rpm -q --quiet HP-CNA-FC-Emulex-Enablement-Kit
    if [ $? -eq 0 ]; then
        if [ -z $KITNAME ]; then
            KITNAME="Core"
        fi
        HBAHPCORELIBSQUERY=`rpm -q HP-CNA-FC-Emulex-Enablement-Kit`
        log_message "Uninstalling HP-CNA-FC-Emulex-Enablement-Kit: $HBAHPCORELIBSQUERY"
        rpm -e $HBAHPCORELIBSQUERY
        CORELIBSSTATUS=$?
        if [ "$CORELIBSSTATUS" = "0" ];then
            log_message "Uninstalling $HBAHPCORELIBSQUERY completed successfully"
        else
            log_message "An error occurred while uninstalling $HBAHPCORELIBSQUERY"
            STATUS=$FAILURE
        fi
        log_message ""
    fi
fi

HBAAPI_LIST=`rpm -qa | grep elxocmlibhbaapi`
if [ $? -eq 0 ]; then
    if [ -z $KITNAME ]; then
        KITNAME="Core"
    fi
    for hbaapirpm in $HBAAPI_LIST
    do
        log_message "Uninstalling elxocmlibhbaapi: $hbaapirpm"
        rpm -e $hbaapirpm
        HBAAPISTATUS=$?
        if [ "$HBAAPISTATUS" = "0" ];then
            log_message "Uninstalling $hbaapirpm completed successfully"
        else
            log_message "An error occurred while uninstalling $hbaapirpm"
            STATUS=$FAILURE
        fi
        log_message ""
   done
fi

rpm -q --quiet elx-udev-config
if [ $? -eq 0 ]; then
    UDEVQUERY=`rpm -q elx-udev-config`
    log_message "Uninstalling elx-udev-config: $UDEVQUERY"
    rpm -e $UDEVQUERY
    UDEVSTATUS=$?
    if [ "$UDEVSTATUS" = "0" ]; then
        log_message "Uninstalling $UDEVQUERY completed successfully"
    else
        log_message "An error occurred while uninstalling $UDEVQUERY"
        STATUS=$FAILURE
    fi
    log_message ""
fi

if [ -n "$KITNAME" ]; then
    if [ $STATUS -eq $FAILURE ]; then
        log_message "An error occurred while uninstalling the OneCommand Manager $KITNAME Kit"
    else
        log_message "OneCommand Manager $KITNAME Kit un-installation completed successfully."
        if [ -d /${INSTALL_DIR}/scripts/ ]; then
            rm -rf /${INSTALL_DIR}/scripts/
        fi
    fi
else
    log_message "OneCommand Manager is not installed."
fi

log_message ""
exit $SUCCESS
