#!/bin/sh
t_flag=0
unset p_hosts
unset n_hosts
#
# Don't show error messages if no npiv capability is supported
#
cmd="ls /sys/class/scsi_host/host*/lpfc_enable_npiv"
eval $cmd > /dev/null 2>&1
#
# Process npiv info only if it is supported
#
if [ $? -eq 0 ] ; then

    hosts=$(ls /sys/class/scsi_host/host*/npiv_info | sed -e 's:/sys/class/scsi_host/::; s:/.*::' |  sed -e 's:host:& :' | sort -n -k 2 | sed -e 's: ::g')
    for host in ${hosts}
      do
      info="$(cat /sys/class/scsi_host/${host}/npiv_info)"
      echo  $info|grep -i physical  > /dev/null 2>&1

      if [ $? -eq 0 ] ; then
	  p_hosts="${p_hosts} ${host}"
      fi

      echo  $info | grep -i "NPIV Not Supported" > /dev/null 2>&1 
      if [ $? -eq 0 ] ; then
	  n_hosts="${n_hosts} ${host}"
      fi
    done
fi
get_nodes () {
    node_host=$1
    wwpn="$(cat /sys/class/fc_host/${node_host}/port_name | sed -e 's:0x::')"
    wwnn="$(cat /sys/class/fc_host/${node_host}/node_name | sed -e 's:0x::')"
}

print_host () {
    pr_host=$1
    info="$(cat /sys/class/scsi_host/${pr_host}/npiv_info)"
    id="$(cat /sys/class/scsi_host/${pr_host}/unique_id)"
    if test -e /sys/class/scsi_host/${pr_host}/modelname; then
        model="$(cat /sys/class/scsi_host/${pr_host}/modelname)"
    else
        model=""
    fi
    if [ ${t_flag} -eq 1  ] ; then
	lpfc_id="  lpfc$id"
    else
	lpfc_id="lpfc$id"
    fi    

    if test -e /sys/class/fc_host/${pr_host}/port_name; then
	get_nodes ${pr_host}
        echo "${lpfc_id}: ${pr_host} $wwpn:$wwnn $model $info"
    else
        echo "${lpfc_id}: ${pr_host} Unknown Unknown $model $info"
    fi
}

get_vhosts () {
    pushd /sys/class/scsi_host > /dev/null 2>&1 
    if [ -e "${host}/device" ] ; then
	v_hosts=$(ls ${host}/device|grep "^host.*"  2> /dev/null  )
    fi

    popd > /dev/null 2>&1 
    if [ -z "${v_hosts}" ] && [ -e '/sys/class/fc_vports' ] 
	then
	pushd /sys/class/fc_vports > /dev/null 2>&1 
	id=$(echo $host|sed s"/[^0-9]//g")
	if [ -n "${id}" ] ; then
	    ls * | grep device  > /dev/null 2>&1
	    status=$?
 	    if [ "${status}" -eq 0 ] ;then
		dev_path=$(ls vport*${id}:*/device > /dev/null 2>&1 )
		status=$?
	        if [ "${status}" -eq 0 ] ;then
		    v_hosts=$(ls vport*${id}:*/device | grep host 2> /dev/null)
		fi
	    fi
	fi
	popd > /dev/null  2>&1 
    fi
}

#
# Print non NPIV Supported hosts
#
for host in $n_hosts 
do
    print_host $host
done
#
# Print NPIV Supported Physical Hosts
#
for host in $p_hosts 
  do
#
# Print NPIV Supported virtual Hosts
#

  get_vhosts
  print_host ${host}
  if [ -n "${v_hosts}" ] ; then
      for vhost in $v_hosts 
	do
	get_nodes $vhost
	t_flag=1
	print_host "${vhost}"
	t_flag=0
      done | sort -k 7 -n
  fi
done

