#!/bin/bash
#
# chkconfig: 35 99 01
# description: Load persistent configuration for Brocade's HBA
#
### BEGIN INIT INFO
# Provides:            bfa
# Required-Start:      $ALL
# Required-Stop:
# Should-Start:        +cron +hwscan
# Default-Start:       3 5
# Default-Stop:        0 1 2 6
# Short-Description:   Brocade Host Bus Adapter
# Description:         Brocade Host Bus Adapter to connect the host system
#                      to other network storage devices.
### END INIT INFO


mkdir -p /opt/brocade/adapter/bfa

CONF="/opt/brocade/adapter/bfa/bfa.conf"
BCUTEMP="/tmp/bcu_out.tmp"
LOG="/opt/brocade/adapter/bfa/bfa.log"

date >> $LOG

if [[ $1 == "stop" ]]; then
	echo stop is called >> ${LOG}
	exit 0
fi

if [[ $1 == "start" ]]; then
	echo start is called >> ${LOG}
fi

if [ -f /bin/vmware ] && [ `vmware -v | awk '{print $2}'` = "ESXi" ]; then
   if [ -d /usr/lib/hostprofiles/plugins/bfaConfig ]; then
	if [ "$1" == "start" ] && [ "$2" == "install" ]; then
		echo start install is called ... exiting >> ${LOG}
		exit 0
	fi
	if [ "$1" == "start" ] && [ "$2" == "upgrade" ]; then
		echo start upgrade is called ... exiting >> ${LOG}
		exit 0
	fi

	# If host profile apply is called, over write the original
	# configuration with the one from the profile
	if [ -f /tmp/bfa_hp_invoked ]; then
		mv /etc/bfa.conf /etc/config/bfa.conf
	fi

	# In case of stateful scenario, /etc/config/bfa.conf is persistent
	# across reboots
	ln -sf /etc/config/bfa.conf /etc/bfa.conf
   fi
fi

set_port_param ()
{
	adapternum=$2
	portnum=$3

	portcmd=$4
	param="$5-$4"
	case $4 in
	 maxfrsize ) portcmd="dfsize";;
	esac

	paramval=`gawk -v pattern="$1-$param" '$1 == pattern  { print $3 }' $CONF`
	if [ ${paramval}x == "x" ]; then
		#echo "No $param setting in $CONF"
		return
	fi 
		
	paramval=`echo ${paramval} | sed 's/"//g'`
	paramval=${paramval%;}
	
	if [ ${portcmd} == "speed" ] && [ ${paramval} == "0" ]; then
		paramval="auto"
	fi

	if [ ${portcmd} == "speed" ]; then
		pattern="Configured port speed"
	elif [ ${portcmd} == "topology" ]; then
		pattern="Configured topology"
	elif [ ${portcmd} == "dfsize" ]; then
		pattern="Port maximum receive data field size"
	fi

	if [ $5 != "auth" ]; then
		issame=`bcu $5 --${portcmd} ${adapternum}/${portnum} | grep "${pattern}" | grep -i "${paramval}"`
	else
		issame=""
	fi

	if [[ "${issame}" == "" ]]; then
		echo +bcu $5 --${portcmd} ${adapternum}/${portnum} ${paramval} >> $LOG
		bcu $5 --${portcmd} ${adapternum}/${portnum} ${paramval} >> $LOG 2>&1
	
		if [ $? == 0 ]; then
			port_recfg=1;
		fi
	fi
}

check_kernel_version()
{
		new_version=0;
	if [ "`uname -r | sed s/[-_]/./g | cut -d\. -f1`" -ge "3" ] || [ "`uname -r | sed s/[-_]/./g | cut -d\. -f3`" -ge "32" ]; then
        new_version=1;
        fi
}

enable_port ()
{
	adapternum=$1
	portnum=$2

	port_id=$adapternum/${portnum}
	echo "+bcu vhba --enable ${port_id}" >> $LOG
	bcu vhba --enable ${port_id} >> $LOG 2>&1
}
	

echo "*******************************************" >> $LOG
if ! [ -f /etc/bfa.conf ]; then
	echo "+bfa.conf doesn't exit, no peristent cfg data..." >> $LOG
	#modprobe bfa
	exit 0
fi

#get the module level persistent configuration
#msix=`gawk '/^msix-disable/ { print $3 }' $CONF`
#msix=${msix%;}

#load the driver in non auto_start mode
#echo +modprobe bfa auto_start=0 msix_disable=${msix:=1} >> $LOG
#modprobe bfa auto_start=0 msix_disable=${msix:=1} 

#if [ $? != 0 ]
#then
#	exit 1
#fi

# RHEL4.9 kudzu work around:- kudzu (hardware detector) in RHEL 4.9
# detects our Network Card but maps this interface to bfa; causing
# BNA load not to be persitent across reboots - add logic to load
# BNA when we detect eth# devices mapped to BFA.
if ! [ "`uname -r | grep "2.6.9-100"`" == "" ]; then
	bna_eth_dev=`grep "alias[[:space:]]\+eth" /etc/modprobe.conf | grep bfa | awk '{ print $2}'`
	if [ -n "$bna_eth_dev" ]; then
		if [ "`lsmod | grep bna`" == "" ]; then
			modprobe bna
		fi
	fi
fi

port_recfg=0
bfa_load=1
bna_load=1

# Check if the bfa is loaded.
bfa_mod=`lsmod | gawk '$1 == "bfa" {print $1}'`
if [[ ! "x"${bfa_mod} == "xbfa" ]]; then
	echo "bfa driver is not loaded." >> $LOG
	bfa_load=0
fi

# Check if the bna is loaded.
bna_mod=`lsmod | gawk '$1 == "bna" {print $1}'`
if [[ ! "x"${bna_mod} == "xbna" ]]; then
	echo "bna driver is not loaded." >> $LOG 
	bna_load=0
fi


if [ "${bfa_load}" == "0" -a "${bna_load}" == "0" ]; then
	echo "exit" >> $LOG
	exit 1;
fi

#CHECK_FOR_TROUBLESHOOT_MODE

echo "bfa: "$bfa_load " bna: "$bna_load >> $LOG

# For newer kernels there is no /dev/bfa and we use the
# /dev/bsg/fc_host# node to do user-space vendor commands;
# wait till this is loaded.
check_kernel_version
if [ "${new_version}" == "1" ]; then
	bfa_pcidev_list=$(ls /sys/bus/pci/drivers/bfa | grep -e '[a-f0-9]\{4\}:[a-f0-9]\{2\}:[a-f0-9]\{2\}.[a-f0-9]')
	for dev_node in $bfa_pcidev_list; do
		bfa_host="`ls /sys/bus/pci/drivers/bfa/$dev_node | grep host`"
		# For Oracle and some distros the udev rules create the bsg
		# fc_host node under /dev rather than /dev/bsg check this path too.
		if [ -e /dev/bsg/fc_$bfa_host ]; then
			bfa_dev_list=( ${bfa_dev_list[@]} "/dev/bsg/fc_$bfa_host" )
		else
			bfa_dev_list=( ${bfa_dev_list[@]} "/dev/fc_$bfa_host" )
		fi
	done
else
	bfa_dev_list=( "/dev/bfa" )
fi

BNA_DEV_NODE="/dev/bna"

loop_cnt=0
MAX_DELAY=15
if [ "${bfa_load}" == "1" ]; then
	#wait until bfa node is created
	for BFA_DEV_NODE in ${bfa_dev_list[@]}; do
		while :
		do
			if [ -c "$BFA_DEV_NODE" ]; then
				break;
			fi

			sleep 1

			loop_cnt=`expr $loop_cnt + 1`
			if [ $loop_cnt -gt $MAX_DELAY ]
			then
				echo "bfa: no $BFA_DEV_NODE" >> $LOG
				exit 1
			fi
		done
	done
fi

loop_cnt=0
if [ "${bna_load}" == "1" ]; then
	#wait until /dev/bna is created
	while :
	do
		if [ -c "$BNA_DEV_NODE" ]; then
			break;
		fi
		sleep 1

		loop_cnt=`expr $loop_cnt + 1`
                if [ $loop_cnt -gt $MAX_DELAY ]
                then
                        echo "bna: no $BNA_DEV_NODE" >> $LOG
                        exit 1
                fi
	done
fi

sleep 2

# ESX5.0 Host-Profile related changes.
# convert hwpath->pwwn
if [ -f /bin/vmware ] && [ `vmware -v | awk '{print $2}'` = "ESXi" ]; then
   # Check if the script is invoked by host-profiles
   if [ -d /usr/lib/hostprofiles/plugins/bfaConfig ] && [ -f /tmp/bfa_hp_invoked ]; then
      cp -f /etc/bfa.conf /tmp/bfa.tmp
      echo "#" > /etc/bfa.conf

      plist=`cat /tmp/bfa.tmp | grep -i "port-wwn" | awk '{print $3}'`
      alist=`bcu adapter --list | grep -v "^-" | grep -v "AD" | awk '{print $1}'`

      for path in $plist; do
         path=`echo $path | awk -F \" '{print $2}'`
	 if [ "$path" = "" ]; then
		continue;
	 fi
         echo "PATH: "$path >> $LOG
         for adapter in $alist; do
            pwwn=`bcu adapter --query $adapter | grep $path -B 2 | grep pwwn | awk '{print $2}'`
	    if [ "$pwwn" = "" ]; then
		continue;
	    fi
            sed -i -e "s/${path}/${pwwn}/" /tmp/bfa.tmp
          done
      done
      cat /tmp/bfa.tmp > /etc/bfa.conf
   fi
fi

cp /etc/bfa.conf /opt/brocade/adapter/bfa/

# Mount the debugfs file system for newer kernels that
# don't mount debugfs by default during reboot.
# only for kernel ver > 2.6.31
if [ "${new_version}" == "1"  ]; then
	if [ "`/bin/mount | grep debugfs`" == "" ]; then
		mount -t debugfs debugfs /sys/kernel/debug 2>/dev/null
	fi
fi

bcu adapter --list | grep ":" | grep -iv "warning" > $BCUTEMP
adapter_list=`gawk '{ print $1 }' $BCUTEMP`
echo adapter list: $adapter_list >> $LOG
port_param_list="speed topology maxfrsize"
auth_param_list_one="algo encrypt"
auth_param_list_two="policy"

for i in $adapter_list;
do
	adapter_sn=`gawk -v pattern=$i '$1 == pattern { print $6 }' $BCUTEMP`
	#adapter_id=`gawk -v pattern="\"${adapter_sn}\";" '$3 == pattern { print $1 }' $CONF`  

	#setup persistent adapter level info: adapter_name
	#adapter_name=`gawk '/'"${adapter_id%-id}""-name"'/  { print $3 }' $CONF`
	adapter_name=`gawk '/'"adapter-""${adapter_sn}""-name"'/  { print $3 }' $CONF`
	adapter_name=`echo ${adapter_name} | sed 's/"//g'`
	adapter_name=${adapter_name%;}
	if [[ "${adapter_name}" != "" ]]; then
		echo +bcu adapter --name $i ${adapter_name} >> $LOG
		bcu adapter --name $i ${adapter_name} >>${LOG} 2>&1
	fi 

	port_num=`gawk -v pattern=$i '$1 == pattern { print $2 }' $BCUTEMP`
	if [ ${port_num} == 2 ]; then
		port_list="0 1"
	else
		port_list="0"
	fi

	echo port_num: $port_num port_list: $port_list >> $LOG

	for j in ${port_list};
	do
		port_recfg=0
		bcu port --query $i/$j > /dev/null 2>&1
		if [ $? != 0 ]; then
			echo port $i/$j is not available! >> ${LOG}
			continue
		fi
		is_NIC=`bcu port --query $i/$j | grep "NIC" |gawk '{ print $3 }'`
		if [ "${is_NIC}" == "NIC" -o "${bfa_load}" == "0" -a "${bna_load}" == "1" ]; then
			mac=`bcu port --query $i/$j | grep "Factory MAC" | tail -1 |gawk '{ print $3 }'`
			portname_entry=`gawk -v pattern="\"${mac}\";" '$3 == pattern && /^bna[0-9]+-port-mac/ { print $1 }' $CONF`
			portname_entry=`echo ${portname_entry} | gawk '{ print $1 }'`
		else
			pwwn=`bcu port --query $i/$j | grep -i "PWWN" | grep -iv "Factory" | gawk '{ print $2 }'`
			portname_entry=`gawk -v pattern="\"${pwwn}\";" '$3 == pattern && /^bfa[0-9]+-port-wwn/ { print $1 }' $CONF`  
			portname_entry=`echo ${portname_entry} | gawk '{ print $1 }'`
		fi
		if ! [ ${portname_entry}x == "x" ]; then
			if [ "${is_NIC}" == "NIC" -o "${bfa_load}" == "0" -a "${bna_load}" == "1" ]; then
				portname=${portname_entry%-port-mac}
				portname_val=`gawk -v pattern=${portname}-port-name '$1 == pattern { print $3}' $CONF`
			else	
				portname=${portname_entry%-port-wwn}
				portname_val=`gawk -v pattern=${portname}-port-name '$1 == pattern { print $3}' $CONF` 
			fi
			#setup port persistent name
			portname_val=`echo ${portname_val} | sed 's/"//g'`
			portname_val=${portname_val%;}
			if [[ "${portname_val}" != "" ]]; then
				echo +bcu port --name $i/$j ${portname_val} >> $LOG
				bcu port --name $i/$j ${portname_val} >>${LOG} 2>&1
			fi

			#setup auth configuration
			for port_param in $auth_param_list_one;
			do
				set_port_param $portname $i $j $port_param "auth"
			done

			#setup log configuration
			set_port_param $portname $i $j "level" "log"

			port_recfg=0

			#setup auth configuration that require port reset
			for port_param in $auth_param_list_two;
			do
				set_port_param $portname $i $j $port_param "auth"
			done

			#setup port configuration
			for port_param in $port_param_list;
			do
				set_port_param $portname $i $j $port_param "port"
			done
			
			#setup fcpim pathtov 
			pathtov=`gawk -v pattern="$portname-pathtov" '$1 == pattern  { print $3 }' $CONF`
			if [ ${pathtov}x != "x" ]; then
				pathtov=`echo ${pathtov} | sed 's/"//g'`
				pathtov=${pathtov%;}
				echo bcu fcpim --pathtov $i/$j ${pathtov} >> $LOG
				bcu fcpim --pathtov $i/$j ${pathtov} >> $LOG
			fi
			
			#vhba interrrupt coalescing
			coalesce=`gawk -v pattern="$portname-coalesce" '$1 == pattern  { print $3 }' $CONF`
			if [ ${coalesce}x != "x" ]; then
				coalesce=`echo ${coalesce} | sed 's/"//g'`
				coalesce=${coalesce%;}
				echo bcu vhba --intr $i/$j -c off >> $LOG
				bcu vhba --intr $i/$j -c off >> $LOG
			else
				latency=`gawk -v pattern="$portname-latency" '$1 == pattern  { print $3 }' $CONF`
				delay=`gawk -v pattern="$portname-delay" '$1 == pattern  { print $3 }' $CONF`
				if [ ${latency}x != "x" ] && [ ${delay}x != "x" ]; then
					latency=`echo ${latency} | sed 's/"//g'`
					latency=${latency%;}
					delay=`echo ${delay} | sed 's/"//g'`
					delay=${delay%;}
					echo bcu vhba --intr $i/$j -c on ${latency} ${delay} >> $LOG
					bcu vhba --intr $i/$j -c on ${latency} ${delay} >> $LOG
				fi
			fi 

			#qos setting
			is_disable=`bcu port --query $i/$j | grep "QOS:" | grep "Disabled"`
			qos=`gawk -v pattern="$portname-qos" '$1 == pattern  { print $3 }' $CONF`
			if [ ${qos}x != "x" ]; then
				qos=`echo ${qos} | sed 's/"//g'`
				qos=${qos%;}
				if [ "${qos}" == "TRUE" ]; then
					if [[ "${is_disable}" != "" ]]; then
						echo bcu qos --enable $i/$j >> $LOG
						bcu qos --enable $i/$j >> $LOG 2>&1
						port_recfg=1;
					fi
				fi
			fi

			#ratelimit setting
			is_disable=`bcu port --query $i/$j | grep "TRL:" | grep "Disabled"`
			ratelim=`gawk -v pattern="$portname-ratelim" '$1 == pattern  { print $3 }' $CONF`
			if [ ${ratelim}x != "x" ]; then
				ratelim=`echo ${ratelim} | sed 's/"//g'`
				ratelim=${ratelim%;}
				if [ ${ratelim} == "TRUE" ]; then
					if [[ "${is_disable}" != "" ]]; then
						echo bcu ratelim --enable $i/$j >> $LOG
						bcu ratelim --enable $i/$j >> $LOG 2>&1
						port_recfg=1;
					fi
				fi
			fi

			#ratelimit speed setting
			ratelim_spd=`gawk -v pattern="$portname-ratelim-defspeed" '$1 == pattern  { print $3 }' $CONF`
			if [ ${ratelim_spd}x != "x" ]; then
				ratelim_spd=`echo ${ratelim_spd} | sed 's/"//g'`
				ratelim_spd=${ratelim_spd%;}
				issame=`bcu port --query $i/$j | grep "TRL default speed" | grep "${ratelim_spd}"`

				if [[ "${issame}" == "" ]]; then	
					if [ ${ratelim_spd} == "1" ] || [ ${ratelim_spd} == "2" ] || 
						[ ${ratelim_spd} == "4" ] || [ ${ratelim_spd} == "8" ] ; then
						echo bcu ratelim --defspeed $i/$j ${ratelim_spd} >> $LOG
						bcu ratelim --defspeed $i/$j ${ratelim_spd} >> $LOG 2>&1
						port_recfg=1;
					fi
				fi
			fi

			#port disable
			port_enable=`gawk -v pattern="$portname-port-enable" '$1 == pattern  { print $3 }' $CONF`
			if [ ${port_enable}x != "x" ]; then
				port_enable=`echo ${port_enable} | sed 's/"//g'`
				port_enable=${port_enable%;}
				if [ ${port_enable} == "FALSE" ]; then
					echo bcu port --disable $i/$j >> $LOG
					bcu port --disable $i/$j >> $LOG
					port_recfg=0;
				fi
			fi

		
			#setup vport
			vport_list=`gawk -v prefix=${portname}-vport- '$1 ~ prefix && \
						/^bfa[0-9]+-vport-/ { print $1 }' $CONF`
			for vport in $vport_list;
			do 
				vport_param=`gawk -F"=" -v prefix=$vport  '$1 ~ prefix {print $2}' $CONF`
				vport_param=`echo ${vport_param} | sed 's/"//g'`
				vport_param=`echo ${vport_param} | sed 's/ //g'`
				vport_param=${vport_param%;}
				vport_param=`echo ${vport_param} | gawk -F";" '{print $1}'`
				wwpn=`echo $vport_param | gawk -F"," '{print $1'}`
				symname=`echo $vport_param | gawk -F"," '{print $3}'`
				role=`echo $vport_param | gawk -F"," '{print $4}'`
				vf=`echo $vport_param | gawk -F"," '{print $5}'`

				if [[ ${vf} != "0" ]] && [[ ${vf} != "" ]]; then
					continue
				fi

				if [[ ${role} != "IM" ]]; then
					continue
				fi
				 
				if [[ ${symname} == "" ]]; then
					echo +bcu vport --create $i/$j ${wwpn} >> $LOG
					bcu vport --create $i/$j ${wwpn} >> $LOG
				else
					echo bcu vport --create $i/$j ${wwpn} -s ${symname} >> $LOG
					bcu vport --create $i/$j ${wwpn} -s ${symname} >> $LOG
				fi
			done

			#Disable TRS
			trs_list=`gawk -v pattern="${portname}-trs-cfg" '$1 == pattern  { print $3 }' $CONF`
			trs_list=`echo ${trs_list} | sed 's/"//g'`
			trs_count=`echo ${trs_list} | gawk -F";" '{print $1}'`
			count=1
			export count
			while [[ $count -le $trs_count ]]
			do
				let count=count+1
				trs_entry=`echo $trs_list | gawk -F";" '{print $ENVIRON["count"]}'`
				lpwwn=`echo $trs_entry | gawk -F"," '{print $1}'`
				rpwwn=`echo $trs_entry | gawk -F"," '{print $2}'`

				echo bcu fcpim --trs_disable $i/$j ${rpwwn} -l ${lpwwn} >> $LOG
				bcu fcpim --trs_disable $i/$j ${rpwwn} -l ${lpwwn} >> $LOG
			done
		fi

		if [ ${port_recfg} == 1 ]; then
			echo bcu port --disable $i/$j >> $LOG 
			bcu port --disable $i/$j >> $LOG 2>&1
			echo bcu port --enable $i/$j >> $LOG
			bcu port --enable $i/$j >> $LOG 2>&1
		fi

		#enable the IOC
		#enable_port $i $j
		echo >> $LOG 
	done

done

rm -f $CONF

exit 0
