#!/bin/bash -l

# net-rename-sideways.sh written by Andrew Cooper
#
# Designed to be called from udev (/etc/udev/rules.d/60-net.rules) to rename
# an unrecognised ethernet device sideways temporerally while there is a risk
# of race conditions.  Later, an RC3 script will take these renamed devices an
# rename them correctly.

# open lock file for reading, as the root filesystem is read only at this point
exec 8<"/etc/udev/scripts/net-rename-sideways.lock"
/usr/bin/flock -x 8

if [[ "$1" =~ "^eth[0-9]+$" ]]
then
    # We have a physical eth device
    # len(name) cannot be greater than 15. Using a 4 digit random number
    # allows for 100 (eth0-eth99) devices to have a temp name without going over
    # 15 byte limit
    name="side-$((RANDOM%9999))-$1"
    while [ -e "/sys/class/net/$name" ]; do
        name="side-$((RANDOM%9999))-$1"
    done

    # This device is going to need to be renamed.  If this is early boot, then
    # interface-rename.py will be called later (at the end of rc.sysinit).
    # However, if this is a post-boot hotplug event causing the renaming, rerunning
    # interface-rename.py is not safe in general, especially if any of the interfaces
    # are already up and passing traffic.

    # If you are happy with rerunning interface-rename.py for post-boot hotplug events,
    # then feel free to uncomment the following line.  You do so at your own risk.

    # ( /etc/udev/scripts/enqueue-interface-rename.sh & disown )

else
    # We have a virtual device, e.g. VLAN deice or possibly a bond
    # As a result, we assume that the underlying physical device has been renamed
    name=$1
fi

echo $name
