/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SENSORACCESS_H_
#define OPENDRIM_SENSORACCESS_H_

#include "Sensors_Common.h"

#include "OpenDRIM_Sensor.h"

int Sensors_OpenDRIM_Sensor_load(const CMPIBroker* broker, string& errorMessage);

int Sensors_OpenDRIM_Sensor_unload(string& errorMessage);

int Sensors_OpenDRIM_Sensor_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Sensor>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_Sensor_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Sensor& instance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_Sensor_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& newInstance, const OpenDRIM_Sensor& oldInstance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_Sensor_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, string& errorMessage);

int Sensors_OpenDRIM_Sensor_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, string& errorMessage);

int Sensors_OpenDRIM_Sensor_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, const OpenDRIM_Sensor_RequestStateChange_In& in, OpenDRIM_Sensor_RequestStateChange_Out& out, string& errorMessage);

int Sensors_OpenDRIM_Sensor_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, const OpenDRIM_Sensor_SetPowerState_In& in, string& errorMessage);

int Sensors_OpenDRIM_Sensor_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_Sensor_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, const OpenDRIM_Sensor_EnableDevice_In& in, string& errorMessage);

int Sensors_OpenDRIM_Sensor_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, const OpenDRIM_Sensor_OnlineDevice_In& in, string& errorMessage);

int Sensors_OpenDRIM_Sensor_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, const OpenDRIM_Sensor_QuiesceDevice_In& in, string& errorMessage);

int Sensors_OpenDRIM_Sensor_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_Sensor_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Sensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_Sensor_populate(OpenDRIM_Sensor& instance, string& errorMessage);

#endif /*OPENDRIM_SENSORACCESS_H_*/
