/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.interceptor;

import alt.jiapi.event.EventInstrumentor;
import alt.jiapi.interceptor.AccessAdvisor;
import alt.jiapi.interceptor.FieldInterceptor;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.Signature;
import alt.jiapi.reflect.SignatureUtil;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.util.HotSpot;
import alt.jiapi.util.HotSpotLocator;
import java.lang.reflect.Modifier;

class FieldAdvisorInstrumentor
extends EventInstrumentor {
    private AccessAdvisor advisor;
    private JiapiMethod getMethod;
    private JiapiMethod setMethod;

    FieldAdvisorInstrumentor(FieldInterceptor fi, AccessAdvisor advisor) {
        super(fi);
        this.advisor = advisor;
        JiapiClass jc = this.getEventProducer();
        try {
            this.getMethod = jc.getDeclaredMethod("getField", new String[]{"java.lang.Object", "java.lang.String", "java.lang.Object"});
            this.setMethod = jc.getDeclaredMethod("setField", new String[]{"java.lang.Object", "java.lang.String", "java.lang.Object"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void instrument(JiapiMethod jm) {
        JiapiClass clazz = jm.getDeclaringClass();
        JiapiField interceptor = this.getEventProducerField();
        InstructionList il = jm.getInstructionList();
        InstructionFactory factory = il.getInstructionFactory();
        HotSpotLocator hsl = new HotSpotLocator(il, new byte[]{-78, -76});
        HotSpot[] hotSpots = hsl.getHotSpots();
        for (int i = 0; i < hotSpots.length; ++i) {
            FieldAccess fa = (FieldAccess)hotSpots[i].getHotSpotInstruction();
            short opCode = fa.getOpcode();
            if (!this.match(fa.getClassName() + "." + fa.getFieldName())) continue;
            InstructionList hsList = hotSpots[i].getInstructionList();
            InstructionList nList = il.createEmptyList();
            boolean primitive = SignatureUtil.isPrimitive(fa.getTypeName());
            if (opCode != -78 && opCode != -76) continue;
            nList.add(factory.getField(interceptor));
            if (opCode == -78) {
                short lvIdx = this.addClassForNameInstructions(fa.getClassName(), jm);
                nList.add(factory.aload(lvIdx));
            } else {
                nList.add(hsList.get(0));
            }
            nList.add(factory.pushConstant(fa.getFieldName()));
            Instruction pIns = null;
            if (primitive) {
                pIns = this.handlePrimitiveType(fa.getTypeName(), nList);
            }
            nList.add(hotSpots[i].getInstructionList());
            if (pIns != null) {
                nList.add(pIns);
            }
            nList.add(factory.invoke(this.getMethod));
            this.handleReturnValue(nList, fa.getTypeName());
            hotSpots[i].getInstructionList().replace(nList);
        }
    }

    private short addClassForNameInstructions(String name, JiapiMethod jm) {
        InstructionList il = jm.getInstructionList();
        InstructionFactory f = il.getInstructionFactory();
        InstructionList nl = il.createEmptyList();
        short maxLocals = (short)jm.getMaxLocals();
        try {
            nl.add(f.pushConstant(name));
            nl.add(f.invoke(8, "java.lang.Class", "forName", new Signature("java.lang.Class", new String[]{"java.lang.String"})));
            nl.add(f.astore(maxLocals));
        }
        catch (Exception e) {
            e.printStackTrace();
            il.add(f.pushNull());
        }
        il.insert(0, nl);
        return maxLocals;
    }

    private boolean isPublicField(FieldAccess fa) {
        try {
            JiapiClass jc = new Loader().loadClass(fa.getClassName());
            JiapiField jf = jc.getField(fa.getName());
            return Modifier.isPublic(jf.getModifiers());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void handleReturnValue(InstructionList il, String rType) {
        InstructionFactory factory = il.getInstructionFactory();
        if ("int".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Integer");
                JiapiMethod jm = jc.getDeclaredMethod("intValue", new String[0]);
                il.add(factory.cast("java.lang.Integer"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("long".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Long");
                JiapiMethod jm = jc.getDeclaredMethod("longValue", new String[0]);
                il.add(factory.cast("java.lang.Long"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("char".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Character");
                JiapiMethod jm = jc.getDeclaredMethod("charValue", new String[0]);
                il.add(factory.cast("java.lang.Character"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("boolean".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Boolean");
                JiapiMethod jm = jc.getDeclaredMethod("booleanValue", new String[0]);
                il.add(factory.cast("java.lang.Boolean"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("byte".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Byte");
                JiapiMethod jm = jc.getDeclaredMethod("byteValue", new String[0]);
                il.add(factory.cast("java.lang.Byte"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("float".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Float");
                JiapiMethod jm = jc.getDeclaredMethod("floatValue", new String[0]);
                il.add(factory.cast("java.lang.Float"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("double".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Double");
                JiapiMethod jm = jc.getDeclaredMethod("doubleValue", new String[0]);
                il.add(factory.cast("java.lang.Double"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("void".equals(rType)) {
            il.add(new Instruction(new byte[]{87}));
        } else {
            il.add(factory.cast(rType));
        }
    }

    private Instruction handlePrimitiveType(String type, InstructionList il) {
        InstructionFactory f = il.getInstructionFactory();
        String cName = null;
        Signature s = new Signature("void", new String[]{type});
        if ("int".equals(type)) {
            cName = "java.lang.Integer";
        } else if ("long".equals(type)) {
            cName = "java.lang.Long";
        } else if ("char".equals(type)) {
            cName = "java.lang.Character";
        } else if ("boolean".equals(type)) {
            cName = "java.lang.Boolean";
        } else if ("byte".equals(type)) {
            cName = "java.lang.Byte";
        } else if ("float".equals(type)) {
            cName = "java.lang.Float";
        } else if ("double".equals(type)) {
            cName = "java.lang.Double";
        }
        il.add(f.newClass(cName));
        il.add(f.dup());
        Instruction ins = f.invoke(1, cName, "<init>", s);
        return ins;
    }
}

